/***********************************************************************
 * $Id:: pinmux.c 8242 2011-10-11 15:15:25Z nxp28536                   $
 *
 * Project: LPC43xx Common
 *
 * Description:
 *     This file can be used as reference for the PINMUX setting.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

scu_pinmux(0x0, 0,MD_PLN,FUNC0);    //  0: gpio0 gpio0_0            1: ssp1 miso1               2: eth rmii enet_rxd1       3: sgpio sgpio_0            4: nc                       5: reserved             6: i2s0 i2stx_ws0           7: i2s1 i2stx_ws1
scu_pinmux(0x0, 1,MD_PLN,FUNC0);    //  0: gpio0 gpio0_1            1: ssp1 mosi1               2: eth rmii enet_col        3: sgpio sgpio_1            4: nc                       5: reserved         6: eth rmii enet_tx_en      7: i2s1 i2stx_sda1

scu_pinmux(0x1, 0,MD_PLN,FUNC0);    //  0: gpio0 gpio0_4            1: sct0 ucap0_3          2: ebi a5                   3: nc                       4: nc                       5: ssp0 ssel0               6: sgpio sgpio_7            7: nc
scu_pinmux(0x1, 1,MD_PLN,FUNC0);    //  0: gpio0 gpio0_8            1: sct0 umat0_7          2: ebi a6                   3: sgpio sgpio_8            4: nc                       5: ssp0 miso0               6: nc                       7: nc
scu_pinmux(0x1, 2,MD_PLN,FUNC0);    //  0: gpio0 gpio0_9            1: sct0 umat0_6          2: ebi a7                   3: sgpio sgpio_9            4: nc                       5: ssp0 mosi0               6: nc                       7: nc
scu_pinmux(0x1, 3,MD_PLN,FUNC0);    //  0: gpio0 gpio0_10           1: sct0 umat0_8          2: sgpio sgpio_10           3: ebi oe                   4: usb0 usb0_ind1           5: ssp1 miso1               6: nc                       7: sdio sdio_rst
scu_pinmux(0x1, 4,MD_PLN,FUNC0);    //  0: gpio0 gpio0_11           1: sct0 umat0_9          2: sgpio sgpio_11           3: ebi bls0                 4: usb0 usb0_ind0           5: ssp1 mosi1               6: nc                       7: sdio sdio_volt1
scu_pinmux(0x1, 5,MD_PLN,FUNC0);    //  0: gpio1 gpio1_8            1: sct0 umat0_10         2: nc                       3: ebi cs0                  4: usb0 usb0_pwr_fault      5: ssp1 ssel1               6: sgpio sgpio_15           7: sdio sdio_pow
scu_pinmux(0x1, 6,MD_PLN,FUNC0);    //  0: gpio1 gpio1_9            1: sct0 ucap0_5          2: nc                       3: ebi we                   4: nc                       5: nc                       6: sgpio sgpio_14           7: sdio sdio_cmd
scu_pinmux(0x1, 7,MD_PLN,FUNC0);    //  0: gpio0 gpio1_0            1: uart1 dsr1               2: sct0 umat0_13         3: ebi d0                   4: usb0 usb0_pwr_en         5: nc                       6: nc                       7: nc
scu_pinmux(0x1, 8,MD_PLN,FUNC0);    //  0: gpio0 gpio1_1            1: uart1 dtr1               2: sct0 umat0_12         3: ebi d1                   4: nc                       5: nc                       6: nc                       7: sdio sdio_volt0
scu_pinmux(0x1, 9,MD_PLN,FUNC0);    //  0: gpio0 gpio1_2            1: uart1 rts1               2: sct0 umat0_11         3: ebi d2                   4: nc                       5: nc                       6: nc                       7: sdio sdio_d0
scu_pinmux(0x1,10,MD_PLN,FUNC0);    //  0: gpio0 gpio1_3            1: uart1 ri1                2: sct0 umat0_14         3: ebi d3                   4: nc                       5: nc                       6: nc                       7: sdio sdio_d1
scu_pinmux(0x1,11,MD_PLN,FUNC0);    //  0: gpio1 gpio1_4            1: uart1 cts1               2: sct0 umat0_15         3: ebi d4                   4: nc                       5: nc                       6: nc                       7: sdio sdio_d2
scu_pinmux(0x1,12,MD_PLN,FUNC0);    //  0: gpio1 gpio1_5            1: uart1 dcd1               2: nc                       3: ebi d5                   4: timer0 cap0_1            5: nc                       6: sgpio sgpio_8            7: sdio sdio_d3
scu_pinmux(0x1,13,MD_PLN,FUNC0);    //  0: gpio1 gpio1_6            1: uart1 txd1               2: nc                       3: ebi d6                   4: timer0 cap0_0            5: nc                       6: sgpio sgpio_9            7: sdio sdio_cd
scu_pinmux(0x1,14,MD_PLN,FUNC0);    //  0: gpio1 gpio1_7            1: uart1 rxd1               2: nc                       3: ebi d7                   4: timer0 mat0_2            5: nc                       6: sgpio sgpio_10           7: nc
scu_pinmux(0x1,15,MD_PLN,FUNC0);    //  0: gpio0 gpio0_2            1: uart2 txd2               2: sgpio sgpio_2            3: eth rmii enet_rxd0       4: timer0 mat0_1            5: nc                       6: nc                       7: nc
scu_pinmux(0x1,16,MD_PLN,FUNC0);    //  0: gpio0 gpio0_3            1: uart2 rxd2               2: sgpio sgpio_3            3: eth rmii enet_crs        4: timer0 mat0_0            5: nc                       6: nc                       7: eth enet_rx_dv
scu_pinmux(0x1,17,MD_PLN,FUNC0);    //  0: gpio0 gpio0_12           1: uart2 uclk2              2: nc                       3: eth rmii enet_mdio       4: timer0 cap0_3            5: can1 td1                 6: sgpio sgpio_11           7: nc
scu_pinmux(0x1,18,MD_PLN,FUNC0);    //  0: gpio0 gpio0_13           1: uart2 dir2               2: nc                       3: eth rmii enet_txd0       4: timer0 mat0_3            5: can1 rd1                 6: sgpio sgpio_12           7: nc
scu_pinmux(0x1,19,MD_PLN,FUNC0);    //  0: eth rmii enet_ref/tx_clk 1: ssp1 sck1                2: nc                       3: nc                       4: cgu clkout               5: nc                       6: i2s0 i2srx_mclk0         7: i2s1 i2stx_clk1
scu_pinmux(0x1,20,MD_PLN,FUNC0);    //  0: gpio0 gpio0_15           1: ssp1 ssel1               2: nc                       3: eth rmii enet_txd1       4: timer0 cap0_2            5: nc                       6: sgpio sgpio_13           7: nc

scu_pinmux(0x2, 0,MD_PLN,FUNC0);    //  0: sgpio sgpio_4            1: uart0 txd0               2: ebi a13                  3: usb0 usb0_pwr_en         4: gpio5 gpio5_0            5: nc                       6: timer3 cap3_0            7: eth enet_mdc
scu_pinmux(0x2, 1,MD_PLN,FUNC0);    //  0: sgpio sgpio_5            1: uart0 rxd0               2: ebi a12                  3: usb0 usb0_pwr_fault      4: gpio5 gpio5_1            5: nc                       6: timer3 cap3_1            7: nc
scu_pinmux(0x2, 2,MD_PLN,FUNC0);    //  0: sgpio sgpio_6            1: uart0 uclk0              2: ebi a11                  3: usb0 usb0_ind1           4: gpio5 gpio5_2            5: sct0 ucap0_6          6: timer3 cap3_2            7: nc
scu_pinmux(0x2, 3,MD_PLN,FUNC0);    //  0: sgpio sgpio_12           1: i2c1 sda1                2: uart3 txd3               3: sct0 ucap0_1          4: gpio5 gpio5_3            5: nc                       6: timer3 mat3_0            7: usb0 usb0_pwr_en
scu_pinmux(0x2, 4,MD_PLN,FUNC0);    //  0: sgpio sgpio_13           1: i2c1 scl1                2: uart3 rxd3               3: sct0 ucap0_0          4: gpio5 gpio5_4            5: nc                       6: timer3 mat3_1            7: usb0 usb0_pwr_fault
scu_pinmux(0x2, 5,MD_PLN,FUNC0);    //  0: sgpio sgpio_14           1: sct0 ucap0_2          2: usb1 usb1_vbus           3: adctrig1                 4: gpio5 gpio5_5            5: nc                       6: timer3 mat3_2            7: usb0 usb0_ind0
scu_pinmux(0x2, 6,MD_PLN,FUNC0);    //  0: sgpio sgpio_7            1: uart0 dir0               2: ebi a10                  3: usb0 usb0_ind0           4: gpio5 gpio5_6            5: sct0 ucap0_7          6: timer3 cap3_3            7: nc
scu_pinmux(0x2, 7,MD_PLN,FUNC0);    //  0: gpio0 gpio0_7            1: sct0 umat0_1          2: uart3 uclk3              3: ebi a9                   4: nc                       5: nc                       6: timer3 mat3_3            7: nc
scu_pinmux(0x2, 8,MD_PLN,FUNC0);    //  0: sgpio sgpio_15           1: sct0 umat0_0          2: uart3 dir3               3: ebi a8                   4: gpio5 gpio5_7            5: nc                       6: nc                       7: nc
scu_pinmux(0x2, 9,MD_PLN,FUNC0);    //  0: gpio1 gpio1_10           1: sct0 umat0_3          2: uart3 baud3              3: ebi a0                   4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x2,10,MD_PLN,FUNC0);    //  0: gpio0 gpio0_14           1: sct0 umat0_2          2: uart2 txd2               3: ebi a1                   4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x2,11,MD_PLN,FUNC0);    //  0: gpio1 gpio1_11           1: sct0 umat0_5          2: uart2 rxd2               3: ebi a2                   4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x2,12,MD_PLN,FUNC0);    //  0: gpio1 gpio1_12           1: sct0 umat0_4          2: nc                       3: ebi a3                   4: reserved3                 5: nc                       6: nc                       7: uart2 uclk2
scu_pinmux(0x2,13,MD_PLN,FUNC0);    //  0: gpio1 gpio1_13           1: sct0 ucap0_4          2: nc                       3: ebi a4                   4: reserved2                 5: nc                       6: nc                       7: uart2 dir2

scu_pinmux(0x3, 0,MD_PLN,FUNC0);    //  0: i2s0 i2srx_clk0          1: i2s0 i2srx_mclk0         2: i2s0 i2stx_clk0          3: i2s i2stx_mclk0          4: ssp0 sck0                5: nc                       6: nc                       7: nc
scu_pinmux(0x3, 1,MD_PLN,FUNC0);    //  0: i2s0 i2stx_ws0           1: i2s0 i2srx_ws0           2: can0 rd0                 3: usb1 usb1_ind1           4: gpio5 gpio5_8            5: reserved5                 6: lcd lcdvd15              7: nc
scu_pinmux(0x3, 2,MD_PLN,FUNC0);    //  0: i2s0 i2stx_sda0          1: i2s0 i2srx_sda0          2: can0 td0                 3: usb1 usb1_ind0           4: gpio5 gpio5_9            5: reserved4                 6: lcd lcdvd14              7: nc
scu_pinmux(0x3, 3,MD_PLN,FUNC0);    //  0: nc                       1: spi sck ssp0             2: sck0 spifi               3: spifi_sck                4: cgu spare1               5: nc                       6: i2s0 i2stx_mclk0         7: i2s1 i2stx_clk1
scu_pinmux(0x3, 4,MD_PLN,FUNC0);    //  0: gpio1 gpio1_14           1: nc                       2: nc                       3: spifi spifi_sio3         4: uart1 txd1               5: i2s0 i2stx_ws0           6: i2s1 i2srx_sda1          7: lcd lcdvd13
scu_pinmux(0x3, 5,MD_PLN,FUNC0);    //  0: gpio1 gpio1_15           1: nc                       2: nc                       3: spifi spifi_sio2         4: uart1 rxd1               5: i2s0 i2stx_sda0          6: i2s1 i2srx_ws1           7: lcd lcdvd12
scu_pinmux(0x3, 6,MD_PLN,FUNC0);    //  0: gpio0 gpio0_6            1: spi miso                 2: ssp0 ssel0               3: spifi spifi_miso         4: nc                       5: ssp0 miso0               6: nc                       7: nc
scu_pinmux(0x3, 7,MD_PLN,FUNC0);    //  0: nc                       1: spi mosi                 2: ssp0 miso0               3: spifi spifi_mosi         4: gpio5 gpio5_10           5: ssp0 mosi0               6: nc                       7: nc
scu_pinmux(0x3, 8,MD_PLN,FUNC0);    //  0: nc                       1: spi ssel                 2: ssp0 mosi0               3: spifi spifi_cs           4: gpio5 gpio5_11           5: ssp0 ssel0               6: nc                       7: nc

scu_pinmux(0x4, 0,MD_PLN,FUNC0);    //  0: gpio2 gpio2_0            1: motocon pwm0_1           2: nmi nmi                  3: nc                       4: nc                       5: lcd lcdvd13              6: uart3 uclk3              7: nc
scu_pinmux(0x4, 1,MD_PLN,FUNC0);    //  0: gpio2 gpio2_1            1: sct0 umat0_1          2: lcd lcdvd0               3: nc                       4: nc                       5: lcd lcdvd19              6: uart3 txd3               7: eth enet_col
scu_pinmux(0x4, 2,MD_PLN,FUNC0);    //  0: gpio2 gpio2_2            1: sct0 umat0_0          2: lcd lcdvd3               3: nc                       4: nc                       5: lcd lcdvd12              6: uart3 rxd3               7: sgpio sgpio_8
scu_pinmux(0x4, 3,MD_PLN,FUNC0);    //  0: gpio2 gpio2_3            1: sct0 umat0_3          2: lcd lcdvd2               3: nc                       4: nc                       5: lcd lcdvd21              6: uart3 baud3              7: sgpio sgpio_9
scu_pinmux(0x4, 4,MD_PLN,FUNC0);    //  0: gpio2 gpio2_4            1: sct0 umat0_2          2: lcd lcdvd1               3: nc                       4: nc                       5: lcd lcdvd20              6: uart3 dir3               7: sgpio sgpio_10
scu_pinmux(0x4, 5,MD_PLN,FUNC0);    //  0: gpio2 gpio2_5            1: sct0 umat0_5          2: lcd lcdfp                3: nc                       4: nc                       5: nc                       6: nc                       7: sgpio sgpio_11
scu_pinmux(0x4, 6,MD_PLN,FUNC0);    //  0: gpio2 gpio2_6            1: sct0 umat0_4          2: lcd lcdac                3: nc                       4: nc                       5: nc                       6: nc                       7: sgpio sgpio_12
scu_pinmux(0x4, 7,MD_PLN,FUNC0);    //  0: lcd lcddclk              1: cgu spifi_clkin          2: nc                       3: nc                       4: nc                       5: nc                       6: i2s1 i2stx_clk1          7: i2s0 i2stx_clk0
scu_pinmux(0x4, 8,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_5          2: lcd lcdvd9               3: nc                       4: gpio5 gpio5_12           5: lcd lcdvd22              6: can1 td1                 7: sgpio sgpio_13
scu_pinmux(0x4, 9,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_6          2: lcd lcdvd11              3: nc                       4: gpio5 gpio5_13           5: lcd lcdvd15              6: can1 rd1                 7: sgpio sgpio_14
scu_pinmux(0x4,10,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_2          2: lcd lcdvd10              3: nc                       4: gpio5 gpio5_14           5: lcd lcdvd14              6: nc                       7: sgpio sgpio_15

scu_pinmux(0x5, 0,MD_PLN,FUNC0);    //  0: gpio2 gpio2_9            1: motocon pwm0_6           2: ebi d12                  3: nc                       4: uart1 dsr1               5: timer1 cap1_0            6: reserved11                7: nc
scu_pinmux(0x5, 1,MD_PLN,FUNC0);    //  0: gpio2 gpio2_10           1: motocon pcap0_2          2: ebi d13                  3: nc                       4: uart1 dtr1               5: timer1 cap1_1            6: reserved10                7: nc
scu_pinmux(0x5, 2,MD_PLN,FUNC0);    //  0: gpio2 gpio2_11           1: motocon pcap0_1          2: ebi d14                  3: nc                       4: uart1 rts1               5: timer1 cap1_2            6: reserved9                 7: nc
scu_pinmux(0x5, 3,MD_PLN,FUNC0);    //  0: gpio2 gpio2_12           1: motocon pcap0_0          2: ebi d15                  3: nc                       4: uart1 ri1                5: timer1 cap1_3            6: reserved8                 7: nc
scu_pinmux(0x5, 4,MD_PLN,FUNC0);    //  0: gpio2 gpio2_13           1: motocon pwm0_2           2: ebi d8                   3: nc                       4: uart1 cts1               5: timer1 mat1_0            6: reserved7                 7: nc
scu_pinmux(0x5, 5,MD_PLN,FUNC0);    //  0: gpio2 gpio2_14           1: motocon pwm0_3           2: ebi d9                   3: nc                       4: uart1 dcd1               5: timer1 mat1_1            6: reserved6                 7: nc
scu_pinmux(0x5, 6,MD_PLN,FUNC0);    //  0: gpio2 gpio2_15           1: motocon pwm0_4           2: ebi d10                  3: nc                       4: uart1 txd1               5: timer1 mat1_2            6: reserved5                 7: nc
scu_pinmux(0x5, 7,MD_PLN,FUNC0);    //  0: gpio2 gpio2_7            1: motocon pwm0_5           2: ebi d11                  3: nc                       4: uart1 rxd1               5: timer1 mat1_3            6: reserved4                 7: nc

scu_pinmux(0x6, 0,MD_PLN,FUNC0);    //  0: nc                       1: i2s0 i2srx_mclk0         2: nc                       3: nc                       4: i2s0 i2srx_clk0          5: nc                       6: nc                       7: nc
scu_pinmux(0x6, 1,MD_PLN,FUNC0);    //  0: gpio3 gpio3_0            1: ebi dycs1                2: uart0 uclk0              3: i2s0 i2srx_ws0           4: nc                       5: timer2 cap2_0            6: nc                       7: nc
scu_pinmux(0x6, 2,MD_PLN,FUNC0);    //  0: gpio3 gpio3_1            1: ebi ckeout1              2: uart0 dir0               3: i2s0 i2srx_sda0          4: nc                       5: timer2 cap2_1            6: nc                       7: nc
scu_pinmux(0x6, 3,MD_PLN,FUNC0);    //  0: gpio3 gpio3_2            1: usb0 usb0_pwr_en         2: sgpio sgpio_4            3: ebi cs1                  4: nc                       5: timer2 cap2_2            6: nc                       7: nc
scu_pinmux(0x6, 4,MD_PLN,FUNC0);    //  0: gpio3 gpio3_3            1: sct0 ucap0_6          2: uart0 txd0               3: ebi cas                  4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x6, 5,MD_PLN,FUNC0);    //  0: gpio3 gpio3_4            1: sct0 umat0_6          2: uart0 rxd0               3: ebi ras                  4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x6, 6,MD_PLN,FUNC0);    //  0: gpio0 gpio0_5            1: ebi bls1                 2: sgpio sgpio_5            3: usb0 usb0_pwr_fault      4: nc                       5: timer2 cap2_3            6: nc                       7: nc
scu_pinmux(0x6, 7,MD_PLN,FUNC0);    //  0: nc                       1: ebi a15                  2: sgpio sgpio_6            3: usb0 usb0_ind1           4: gpio5 gpio5_15           5: timer2 mat2_0            6: nc                       7: nc
scu_pinmux(0x6, 8,MD_PLN,FUNC0);    //  0: nc                       1: ebi a14                  2: sgpio sgpio_7            3: usb0 usb0_ind0           4: gpio5 gpio5_16           5: timer2 mat2_1            6: nc                       7: nc
scu_pinmux(0x6, 9,MD_PLN,FUNC0);    //  0: gpio3 gpio3_5            1: nc                       2: nc                       3: ebi dycs0                4: nc                       5: timer2 mat2_2            6: nc                       7: nc
scu_pinmux(0x6,10,MD_PLN,FUNC0);    //  0: gpio3 gpio3_6            1: motocon fes_n            2: nc                       3: ebi dqmout1              4: nc                       5: nc                       6: nc                       7: nc
scu_pinmux(0x6,11,MD_PLN,FUNC0);    //  0: gpio3 gpio3_7            1: nc                       2: nc                       3: ebi ckeout0              4: nc                       5: timer2 mat2_3            6: nc                       7: nc
scu_pinmux(0x6,12,MD_PLN,FUNC0);    //  0: gpio2 gpio2_8            1: sct0 umat0_7          2: nc                       3: ebi dqmout0              4: nc                       5: nc                       6: nc                       7: nc

scu_pinmux(0x7, 0,MD_PLN,FUNC0);    //  0: gpio3 gpio3_8            1: sct0 umat0_14         2: nc                       3: lcd lcdle                4: nc                       5: nc                       6: nc                       7: sgpio sgpio_4
scu_pinmux(0x7, 1,MD_PLN,FUNC0);    //  0: gpio3 gpio3_9            1: sct0 umat0_15         2: i2s0 i2stx_ws0           3: lcd lcdvd19              4: lcd lcdvd7               5: nc                       6: uart2 txd2               7: sgpio sgpio_5
scu_pinmux(0x7, 2,MD_PLN,FUNC0);    //  0: gpio3 gpio3_10           1: sct0 ucap0_4          2: i2s0 i2stx_sda0          3: lcd lcdvd18              4: lcd lcdvd6               5: nc                       6: uart2 rxd2               7: sgpio sgpio_6
scu_pinmux(0x7, 3,MD_PLN,FUNC0);    //  0: gpio3 gpio3_11           1: sct0 ucap0_3          2: nc                       3: lcd lcdvd17              4: lcd lcdvd5               5: nc                       6: nc                       7: nc
scu_pinmux(0x7, 4,MD_PLN,FUNC0);    //  0: gpio3 gpio3_12           1: sct0 umat0_13         2: nc                       3: lcd lcdvd16              4: lcd lcdvd4               5: etm trace_data0          6: nc                       7: nc
scu_pinmux(0x7, 5,MD_PLN,FUNC0);    //  0: gpio3 gpio3_13           1: sct0 umat0_12         2: nc                       3: lcd lcdvd8               4: lcd lcdvd23              5: etm trace_data1          6: nc                       7: nc
scu_pinmux(0x7, 6,MD_PLN,FUNC0);    //  0: gpio3 gpio3_14           1: sct0 umat0_11         2: nc                       3: lcd lcdlp                4: nc                       5: etm trace_data2          6: nc                       7: nc
scu_pinmux(0x7, 7,MD_PLN,FUNC0);    //  0: gpio3 gpio3_15           1: sct0 umat0_8          2: nc                       3: lcd lcdpwr               4: nc                       5: etm trace_data3          6: eth enet_mdc             7: sgpio sgpio_7

scu_pinmux(0x8, 0,MD_PLN,FUNC0);    //  0: gpio4 gpio4_0            1: usb0 usb0_pwr_fault      2: nc                       3: motocon pcap0_2          4: sgpio sgpio_8            5: nc                       6: nc                       7: timer0 mat0_0
scu_pinmux(0x8, 1,MD_PLN,FUNC0);    //  0: gpio4 gpio4_1            1: usb0 usb0_ind1           2: nc                       3: motocon pcap0_1          4: sgpio sgpio_9            5: nc                       6: nc                       7: timer0 mat0_1
scu_pinmux(0x8, 2,MD_PLN,FUNC0);    //  0: gpio4 gpio4_2            1: usb0 usb0_ind0           2: nc                       3: motocon pcap0_0          4: sgpio sgpio_10           5: nc                       6: nc                       7: timer0 mat0_2
scu_pinmux(0x8, 3,MD_PLN,FUNC0);    //  0: gpio4 gpio4_3            1: usb1 ulpi_data2          2: nc                       3: lcd lcdvd12              4: lcd lcdvd19              5: nc                       6: nc                       7: timer0 mat0_3
scu_pinmux(0x8, 4,MD_PLN,FUNC0);    //  0: gpio4 gpio4_4            1: usb1 ulpi_data1          2: nc                       3: lcd lcdvd7               4: lcd lcdvd16              5: nc                       6: nc                       7: timer0 cap0_0
scu_pinmux(0x8, 5,MD_PLN,FUNC0);    //  0: gpio4 gpio4_5            1: usb1 ulpi_data0          2: nc                       3: lcd lcdvd6               4: lcd lcdvd8               5: nc                       6: nc                       7: timer0 cap0_1
scu_pinmux(0x8, 6,MD_PLN,FUNC0);    //  0: gpio4 gpio4_6            1: usb1 ulpi_nxt            2: nc                       3: lcd lcdvd5               4: lcd lcdlp                5: nc                       6: nc                       7: timer0 cap0_2
scu_pinmux(0x8, 7,MD_PLN,FUNC0);    //  0: gpio4 gpio4_7            1: usb1 ulpi_stp            2: nc                       3: lcd lcdvd4               4: lcd lcdpwr               5: nc                       6: nc                       7: timer0 cap0_3
scu_pinmux(0x8, 8,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_clk            2: nc                       3: nc                       4: nc                       5: nc                       6: cgu spare0               7: i2s1 i2stx_mclk1

scu_pinmux(0x9, 0,MD_PLN,FUNC0);    //  0: gpio4 gpio4_12           1: motocon fes_n            2: nc                       3: nc                       4: nc                       5: eth rmii enet_crs        6: sgpio sgpio_0            7: ssp0 ssel0
scu_pinmux(0x9, 1,MD_PLN,FUNC0);    //  0: gpio4 gpio4_13           1: motocon pwm0_5           2: nc                       3: nc                       4: i2s0 i2stx_ws0           5: eth enet_rx_er           6: sgpio sgpio_1            7: ssp0 miso0
scu_pinmux(0x9, 2,MD_PLN,FUNC0);    //  0: gpio4 gpio4_14           1: motocon pwm0_6           2: nc                       3: nc                       4: i2s0 i2stx_sda0          5: eth enet_rxd3            6: sgpio sgpio_2            7: ssp0 mosi0
scu_pinmux(0x9, 3,MD_PLN,FUNC0);    //  0: gpio4 gpio4_15           1: motocon pwm0_1           2: usb1 usb1_ind1           3: nc                       4: nc                       5: eth enet_rxd2            6: sgpio sgpio_9            7: uart3 txd3
scu_pinmux(0x9, 4,MD_PLN,FUNC0);    //  0: nc                       1: motocon pwm0_2           2: usb1 usb1_ind0           3: nc                       4: gpio5 gpio5_17           5: eth enet_txd2            6: sgpio sgpio_4            7: uart3 rxd3
scu_pinmux(0x9, 5,MD_PLN,FUNC0);    //  0: nc                       1: motocon pwm0_3           2: usb1 usb1_vbus_en        3: nc                       4: gpio5 gpio5_18           5: eth enet_txd3            6: sgpio sgpio_3            7: uart0 txd0
scu_pinmux(0x9, 6,MD_PLN,FUNC0);    //  0: gpio4 gpio4_11           1: motocon pwm0_4           2: usb1 usb1_pwr_fault      3: nc                       4: nc                       5: eth enet_col             6: sgpio sgpio_8            7: uart0 rxd0

scu_pinmux(0xA, 0,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: nc                       3: nc                       4: nc                       5: i2s1 i2srx_mclk1         6: cgu spare1               7: nc
scu_pinmux(0xA, 1,MD_PLN,FUNC0);    //  0: gpio4 gpio4_8            1: qei qei_idx              2: nc                       3: uart2 txd2               4: nc                       5: reserved reserved12                6: nc                       7: nc
scu_pinmux(0xA, 2,MD_PLN,FUNC0);    //  0: gpio4 gpio4_9            1: qei qei_b                2: nc                       3: uart2 rxd2               4: nc                       5: reserved reserved13                6: nc                       7: nc
scu_pinmux(0xA, 3,MD_PLN,FUNC0);    //  0: gpio4 gpio4_10           1: qei qei_a                2: nc                       3: nc                       4: nc                       5: reserved reserved14                6: nc                       7: nc
scu_pinmux(0xA, 4,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_9          2: nc                       3: ebi a23                  4: gpio5 gpio5_19           5: reserved reserved15                6: nc                       7: nc

scu_pinmux(0xB, 0,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_10         2: lcd lcdvd23              3: nc                       4: gpio5 gpio5_20           5: nc                       6: nc                       7: nc
scu_pinmux(0xB, 1,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_dir            2: lcd lcdvd22              3: nc                       4: gpio5 gpio5_21           5: sct0 umat0_6          6: nc                       7: nc
scu_pinmux(0xB, 2,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data7          2: lcd lcdvd21              3: nc                       4: gpio5 gpio5_22           5: sct0 umat0_7          6: nc                       7: nc
scu_pinmux(0xB, 3,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data6          2: lcd lcdvd20              3: nc                       4: gpio5 gpio5_23           5: sct0 umat0_8          6: nc                       7: nc
scu_pinmux(0xB, 4,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data5          2: lcd lcdvd15              3: nc                       4: gpio5 gpio5_24           5: sct0 ucap0_5          6: nc                       7: nc
scu_pinmux(0xB, 5,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data4          2: lcd lcdvd14              3: nc                       4: gpio5 gpio5_25           5: sct0 ucap0_7          6: lcd lcdpwr               7: nc
scu_pinmux(0xB, 6,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data3          2: lcd lcdvd13              3: nc                       4: gpio5 gpio5_26           5: sct0 ucap0_6          6: lcd lcdvd19              7: nc

scu_pinmux(0xC, 0,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_clknc          2: eth enet_rx_clk          3: lcd lcddclk              4: nc                       5: nc                       6: sdio sdio_clk
scu_pinmux(0xC, 1,MD_PLN,FUNC0);    //  0: usb1 ulpi_data7          1: nc                       2: uart1 ri1                3: eth enet_mdc             4: gpio6 gpio6_0            5: nc                       6: timer3 cap3_0            7: sdio sdio_volt0
scu_pinmux(0xC, 2,MD_PLN,FUNC0);    //  0: usb1 ulpi_data6          1: nc                       2: uart1 cts1               3: eth enet_txd2            4: gpio6 gpio6_1            5: nc                       6: nc                       7: sdio sdio_rst
scu_pinmux(0xC, 3,MD_PLN,FUNC0);    //  0: usb1 ulpi_data5          1: nc                       2: uart1 rts1               3: eth enet_txd3            4: gpio6 gpio6_2            5: nc                       6: nc                       7: sdio sdio_volt1
scu_pinmux(0xC, 4,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data4          2: nc                       3: eth enet_tx_en           4: gpio6 gpio6_3            5: nc                       6: timer3 cap3_1            7: sdio sdio_d0
scu_pinmux(0xC, 5,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data3          2: nc                       3: eth enet_tx_er           4: gpio6 gpio6_4            5: nc                       6: timer3 cap3_2            7: sdio sdio_d1
scu_pinmux(0xC, 6,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data2          2: nc                       3: eth enet_rxd2            4: gpio6 gpio6_5            5: nc                       6: timer3 cap3_3            7: sdio sdio_d2
scu_pinmux(0xC, 7,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data1          2: nc                       3: eth enet_rxd3            4: gpio6 gpio6_6            5: nc                       6: timer3 mat3_0            7: sdio sdio_d3
scu_pinmux(0xC, 8,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_data0          2: nc                       3: eth enet_rx_dv           4: gpio6 gpio6_7            5: nc                       6: timer3 mat3_1            7: sdio sdio_cd
scu_pinmux(0xC, 9,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_nxt            2: nc                       3: eth enet_rx_er           4: gpio6 gpio6_8            5: nc                       6: timer3 mat3_2            7: sdio sdio_pow
scu_pinmux(0xC,10,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_stp            2: uart1 dsr1               3: nc                       4: gpio6 gpio6_9            5: nc                       6: timer3 mat3_3            7: sdio sdio_cmd
scu_pinmux(0xC,11,MD_PLN,FUNC0);    //  0: nc                       1: usb1 ulpi_dir            2: uart1 dcd1               3: nc                       4: gpio6 gpio6_10           5: nc                       6: nc                       7: sdio sdio_d4
scu_pinmux(0xC,12,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: uart1 dtr1               3: nc                       4: gpio6 gpio6_11           5: sgpio sgpio_11           6: i2s0 i2stx_sda0          7: sdio sdio_d5
scu_pinmux(0xC,13,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: uart1 txd1               3: nc                       4: gpio6 gpio6_12           5: sgpio sgpio_12           6: i2s0 i2stx_ws0           7: sdio sdio_d6
scu_pinmux(0xC,14,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: uart1 rxd1               3: nc                       4: gpio6 gpio6_13           5: sgpio sgpio_13           6: eth enet_tx_er           7: sdio sdio_d7

scu_pinmux(0xD, 0,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_15         2: ebi dqmout2              3: nc                       4: gpio6 gpio6_14           5: nc                       6: nc                       7: sgpio sgpio_4
scu_pinmux(0xD, 1,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi ckeout2              3: nc                       4: gpio6 gpio6_15           5: sdio sdio_pow            6: nc                       7: sgpio sgpio_5
scu_pinmux(0xD, 2,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_7          2: ebi d16                  3: nc                       4: gpio6 gpio6_16           5: nc                       6: nc                       7: sgpio sgpio_6
scu_pinmux(0xD, 3,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_6          2: ebi d17                  3: nc                       4: gpio6 gpio6_17           5: nc                       6: nc                       7: sgpio sgpio_7
scu_pinmux(0xD, 4,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_8          2: ebi d18                  3: nc                       4: gpio6 gpio6_18           5: nc                       6: nc                       7: sgpio sgpio_8
scu_pinmux(0xD, 5,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_9          2: ebi d19                  3: nc                       4: gpio6 gpio6_19           5: nc                       6: nc                       7: sgpio sgpio_9
scu_pinmux(0xD, 6,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_10         2: ebi d20                  3: nc                       4: gpio6 gpio6_20           5: nc                       6: nc                       7: sgpio sgpio_10
scu_pinmux(0xD, 7,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_5          2: ebi d21                  3: nc                       4: gpio6 gpio6_21           5: nc                       6: nc                       7: sgpio sgpio_11
scu_pinmux(0xD, 8,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_6          2: ebi d22                  3: nc                       4: gpio6 gpio6_22           5: nc                       6: nc                       7: sgpio sgpio_12
scu_pinmux(0xD, 9,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_13         2: ebi d23                  3: nc                       4: gpio6 gpio6_23           5: nc                       6: nc                       7: sgpio sgpio_13
scu_pinmux(0xD,10,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_1          2: ebi bls3                 3: nc                       4: gpio6 gpio6_24           5: nc                       6: nc                       7: nc
scu_pinmux(0xD,11,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi cs3                  3: nc                       4: gpio6 gpio6_25           5: usb1 ulpi_data0          6: sct0 umat0_14         7: nc
scu_pinmux(0xD,12,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi cs2                  3: nc                       4: gpio6 gpio6_26           5: nc                       6: sct0 umat0_10         7: nc
scu_pinmux(0xD,13,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_0          2: ebi bls2                 3: nc                       4: gpio6 gpio6_27           5: nc                       6: sct0 umat0_13         7: nc
scu_pinmux(0xD,14,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi dycs2                3: nc                       4: gpio6 gpio6_28           5: nc                       6: sct0 umat0_11         7: nc
scu_pinmux(0xD,15,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi a17                  3: nc                       4: gpio6 gpio6_29           5: sdio sdio_wp             6: sct0 umat0_8          7: nc
scu_pinmux(0xD,16,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ebi a16                  3: nc                       4: gpio6 gpio6_30           5: sdio sdio_volt2          6: sct0 umat0_12         7: nc

scu_pinmux(0xE, 0,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: nc                       3: ebi a18                  4: gpio7 gpio7_0            5: can1 td1                 6: nc                       7: nc
scu_pinmux(0xE, 1,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: nc                       3: ebi a19                  4: gpio7 gpio7_1            5: can1 rd1                 6: nc                       7: nc
scu_pinmux(0xE, 2,MD_PLN,FUNC0);    //  0: adctrig0                 1: can0 rd0                 2: nc                       3: ebi a20                  4: gpio7 gpio7_2            5: reserved3                 6: nc                       7: nc
scu_pinmux(0xE, 3,MD_PLN,FUNC0);    //  0: nc                       1: can0 td0                 2: adctrig1                 3: ebi a21                  4: gpio7 gpio7_3            5: reserved1                 6: nc                       7: nc
scu_pinmux(0xE, 4,MD_PLN,FUNC0);    //  0: nc                       1: nmi nmi                  2: nc                       3: ebi a22                  4: gpio7 gpio7_4            5: reserved0                 6: nc                       7: nc
scu_pinmux(0xE, 5,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_3          2: uart1 rts1               3: ebi d24                  4: gpio7 gpio7_5            5: reserved11                6: nc                       7: nc
scu_pinmux(0xE, 6,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_2          2: uart1 ri1                3: ebi d25                  4: gpio7 gpio7_6            5: reserved10                6: nc                       7: nc
scu_pinmux(0xE, 7,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_5          2: uart1 cts1               3: ebi d26                  4: gpio7 gpio7_7            5: reserved9                 6: nc                       7: nc
scu_pinmux(0xE, 8,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_4          2: uart1 dsr1               3: ebi d27                  4: gpio7 gpio7_8            5: reserved8                 6: nc                       7: nc
scu_pinmux(0xE, 9,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_4          2: uart1 dcd1               3: ebi d28                  4: gpio7 gpio7_9            5: reserved7                 6: nc                       7: nc
scu_pinmux(0xE,10,MD_PLN,FUNC0);    //  0: nc                       1: sct0 ucap0_3          2: uart1 dtr1               3: ebi d29                  4: gpio7 gpio7_10           5: reserved6                 6: nc                       7: nc
scu_pinmux(0xE,11,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_12         2: uart1 txd1               3: ebi d30                  4: gpio7 gpio7_11           5: reserved5                 6: nc                       7: nc
scu_pinmux(0xE,12,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_11         2: uart1 rxd1               3: ebi d31                  4: gpio7 gpio7_12           5: reserved4                 6: nc                       7: nc
scu_pinmux(0xE,13,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_14         2: i2c1 sda1                3: ebi dqmout3              4: gpio7 gpio7_13           5: nc                       6: nc                       7: nc
scu_pinmux(0xE,14,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: nc                       3: ebi dycs3                4: gpio7 gpio7_14           5: reserved2                 6: nc                       7: nc
scu_pinmux(0xE,15,MD_PLN,FUNC0);    //  0: nc                       1: sct0 umat0_0          2: i2c1 scl1                3: ebi ckeout3              4: gpio7 gpio7_15           5: nc                       6: nc                       7: nc

scu_pinmux(0xF, 0,MD_PLN,FUNC0);    //  0: ssp0 sck0                1: cgu spifi_clkin          2: nc                       3: nc                       4: nc                       5: nc                       6: nc                       7: i2s1 i2stx_mclk1
scu_pinmux(0xF, 1,MD_PLN,FUNC0);    //  0: nc                       1: nc                       2: ssp0 ssel0               3: nc                       4: gpio7 gpio7_16           5: nc                       6: sgpio sgpio_0            7: nc
scu_pinmux(0xF, 2,MD_PLN,FUNC0);    //  0: nc                       1: uart3 txd3               2: ssp0 miso0               3: nc                       4: gpio7 gpio7_17           5: nc                       6: sgpio sgpio_1            7: nc
scu_pinmux(0xF, 3,MD_PLN,FUNC0);    //  0: nc                       1: uart3 rxd3               2: ssp0 mosi0               3: nc                       4: gpio7 gpio7_18           5: nc                       6: sgpio sgpio_2            7: nc
scu_pinmux(0xF, 4,MD_PLN,FUNC0);    //  0: ssp1 sck1                1: cgu spifi_clkin          2: etm trace_clk            3: nc                       4: nc                       5: nc                       6: i2s0 i2stx_mclk0         7: i2s0 i2srx_clk0
scu_pinmux(0xF, 5,MD_PLN,FUNC0);    //  0: nc                       1: uart3 uclk3              2: ssp1 ssel1               3: etm trace_data0          4: gpio7 gpio7_19           5: nc                       6: sgpio sgpio_4            7: nc
scu_pinmux(0xF, 6,MD_PLN,FUNC0);    //  0: nc                       1: uart3 dir3               2: ssp1 miso1               3: etm trace_data1          4: gpio7 gpio7_20           5: nc                       6: sgpio sgpio_5            7: i2s1 i2stx_sda1
scu_pinmux(0xF, 7,MD_PLN,FUNC0);    //  0: nc                       1: uart3 baud3              2: ssp1 mosi1               3: etm trace_data2          4: gpio7 gpio7_21           5: nc                       6: sgpio sgpio_6            7: i2s1 i2stx_ws1
scu_pinmux(0xF, 8,MD_PLN,FUNC0);    //  0: nc                       1: uart0 uclk0              2: sct0 ucap0_2          3: etm trace_data3          4: gpio7 gpio7_22           5: nc                       6: sgpio sgpio_7            7: nc
scu_pinmux(0xF, 9,MD_PLN,FUNC0);    //  0: nc                       1: uart0 dir0               2: sct0 umat0_1          3: nc                       4: gpio7 gpio7_23           5: nc                       6: sgpio sgpio_3            7: nc
scu_pinmux(0xF,10,MD_PLN,FUNC0);    //  0: nc                       1: uart0 txd0               2: nc                       3: nc                       4: gpio7 gpio7_24           5: nc                       6: sdio sdio_wp             7: nc
scu_pinmux(0xF,11,MD_PLN,FUNC0);    //  0: nc                       1: uart0 rxd0               2: nc                       3: nc                       4: gpio7 gpio7_25           5: nc                       6: sdio sdio_volt2          7: nc
